/**************************************************************************
 *
 *  THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY
 *  KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 *  IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR
 *  PURPOSE.
 *
 *  Copyright (c) 1992-1995 David Johnston.  All Rights Reserved.   
 *
 *  This code is provided for sample purposes only.  
 * 
 **************************************************************************/
 
#include <windows.h>
#include <math.h>        
//#include <stdio.h>

#include "xfmsdll.c" 
#include "resource.h"

// Usa an Internal Structure for your function, and access it through a handle
typedef struct distort_tag
{	HANDLE		hGraph;					/* Graphical input device */
} DISTORT;

// Structure Definition for Preset and Script handling
// list variable types as:  c char
//							b BOOL
//							i int or WORD 
//							f float
//							l long or DWORD
//							d double
//							g GRAPH
//							h Global Handle  
//							s String of 256 chars
//
// Structure Preset Vars: 'y' to include in presets, 'n' to ignore.

#define STRUCTDEFINITION "g"
#define PRESETDEFINITION "y"
#define TRANSFORMNAME "Distortion"

//#define dsetitem(Id,dVal) sprintf(tmp,"%g",dVal); SetDlgItemText(hWndDlg,Id,tmp)

#define MEMSIZE 64000

//HANDLE hAmp;
//DISTORT far * pAmp;

/****************************************************************************/
//      LibMain
//
//      PURPOSE:  Standard LibMain called from LIBENTRY.OBJ
//         
/****************************************************************************/

int FAR PASCAL LibMain(HANDLE hModule, WORD wDataSeg, WORD cbHeapSize, LPSTR lpszCmdLine)
{
    return 1;
}


/****************************************************************************/
//    WEP
//
//    PURPOSE:  No tasks to unload.  Returns success.
//
/*****************************************************************************/

int FAR PASCAL __export _WEP (int bSystemExit)
{
    return(1);
}

// Fill XFMQUERY structure with information regarding this file filter

int FAR PASCAL __export QueryXfm(XFMQUERY far * cq)
{   lstrcpy(cq->szName,TRANSFORMNAME);         
	lstrcpy(cq->szCopyright,"");                            
	
	cq->wSupports=XFM_MONO8|XFM_STEREO8|XFM_MONO16|XFM_STEREO16|0x8000;	
	cq->dwFlags=XF_TRANSFORM|XF_USESPRESETSAPI|XF_USESGRAPHAPI|XF_MUSTHIGHLIGHT;
	cq->dwUserDataLength = sizeof(DISTORT);
	lstrcpy(cq->szStructDef,STRUCTDEFINITION);
	lstrcpy(cq->szPresetDef,PRESETDEFINITION);
	lstrcpy(cq->szToolHelp,"Add Distortion/Grunge/Overdrive effects");
	return XFM_VALIDLIBRARY;
} 

BOOL FAR PASCAL __export XfmInit(COOLINFO far *ci)
{	DISTORT FAR * lpAmp;
	HANDLE hDistort;
	hDistort=ci->hUserData;         
	lpAmp=(DISTORT FAR *)GlobalLock(hDistort);
	if (!lpAmp)
		return FALSE;
	lpAmp->hGraph=GraphCreate(ci,0,16384,0,16384,0,16384); 
	GlobalUnlock(hDistort);
	return TRUE;
}

BOOL FAR PASCAL __export XfmDestroy(COOLINFO far *ci)
{   DISTORT FAR * lpAmp;
	HANDLE hDistort;
	hDistort=ci->hUserData;         
	lpAmp=(DISTORT FAR *)GlobalLock(hDistort);
	if (!lpAmp)
		return FALSE;
 	if (lpAmp->hGraph)
 	{	GraphDestroy(ci,lpAmp->hGraph);
 		lpAmp->hGraph=NULL;
 	}                   
 	GlobalUnlock(hDistort);
 	
}

BOOL FAR PASCAL __export XfmSetup(HWND hWnd, HINSTANCE hInst, COOLINFO far *ci)
{	int nRc;
	FARPROC lpfnDIALOGMsgProc;
	
	lpfnDIALOGMsgProc = GetProcAddress(hInst,(LPCSTR)MAKELONG(100,0));
	
	nRc = DialogBoxParam((HINSTANCE)hInst,(LPCSTR)MAKEINTRESOURCE(IDD_TRANSFORM), (HWND)hWnd, (DLGPROC)lpfnDIALOGMsgProc,(DWORD)ci);
	
	return nRc;
}

#define LIMIT 2048
#define GOTO 32767

BOOL FAR PASCAL __export XfmDo(COOLINFO far *ci)
{	DISTORT FAR * lpAmp = NULL;
	HANDLE hDistort = NULL;
	DWORD losamp, hisamp;
	
	HANDLE hBigMem=NULL;
	unsigned char huge *data;
	int huge *datai;
	DWORD length;
	DWORD offset;
	DWORD origsize;                
	DWORD maxsize; 
	
	HANDLE hInts=NULL;
	int far *pInts=NULL;   
	int i;
	
    hInts=GlobalAlloc(GMEM_MOVEABLE,16385*sizeof(int));
    if (!hInts) return 1;
    pInts=(int far *)GlobalLock(hInts);
    if (!pInts)
    {	GlobalFree(hInts);
    	return 1;
    }
    
    hDistort=ci->hUserData;         
	lpAmp=(DISTORT FAR *)GlobalLock(hDistort);
	losamp=ci->dwLoSample;
	hisamp=ci->dwHiSample;
	
	maxsize=MEMSIZE/4;
 	maxsize=(maxsize/16)*16;
    
	hBigMem=GlobalAlloc(GMEM_MOVEABLE,(DWORD)MEMSIZE+1000);
	if (hBigMem==NULL)
		return 1;
  
 	data=GlobalLock(hBigMem);
	if (data==NULL) 
	{	GlobalFree(hBigMem);
		hBigMem=0;
		return 1;
	}
	datai=(int huge *)data;
    
    ProgressCreate(ci,"Distorting Selection",NULL);
    
    origsize=length=(hisamp-losamp+1)*ci->wBlockAlign;
 	offset=losamp*ci->wBlockAlign;
 	
// build int conversion table
	for (i=0;i<16385;i++)
	{	pInts[i]=min(16383,(int)GraphGetValueAt(ci,lpAmp->hGraph,(double)i/16384.0));
		
//		if (i>16380)
//		{	char m[40];
//			wsprintf(m,"%d: %d\n",i,pInts[i]);
//			OutputDebugString(m);
//		}		
 	}
 	
	while (length!=0)
 	{	DWORD amount,amount2;
 	 	DWORD t;
		int value;
 		int m2;
 		int sgn;
		
		amount=length;
		if (amount>maxsize) amount=maxsize;
		amount2=amount/2;
		length-=amount;
		ReadData(ci,data,offset,amount);
		
		if (ci->wChannels==1)
 	 	{	if (ci->wBitsPerSample==16)
 	 		{	for (t=0;t<amount2;t++)
 	         	{	sgn=1;
 	         		value=datai[t];
 	         	    if (value<0)
 	         	    {	sgn=-1;
 	         	    	value=-value; 	         	    	
 	         	    }                
 	         	    m2=value%2; 	         		
 	         		value=(int)(((pInts[value>>1])<<1)+m2);
 	         		if (sgn<0)
 	         			datai[t]=-value;
 	         		else
 	         			datai[t]=value; 	         		
 	         	}
 	        }
 	     	else  // 8-bit
 	     	{	for (t=0;t<amount;t++)
 	         	{	sgn=1;
 	         		value=(int)(data[t]-128);
 	         	    if (value<0)
 	         	    {	sgn=-1;
 	         	    	value=-value; 	         	    	
 	         	    }                
 	         	    m2=value%2; 	         		
 	         		value=(int)(((pInts[value<<7])<<1)+m2)>>8;
 	         		if (sgn<0)
 	         			data[t]=(unsigned char)(128-value);
 	         		else
 	         			data[t]=(unsigned char)(128+value);
  	         	} 	     		
 	     	}
 	    }
 	 	else
 	 	{	if (ci->wBitsPerSample==16)   // 16-bit stereo
 	 		{	for (t=0;t<amount2;)
 	    	 	{	
 	    	 		sgn=1;
 	         		value=datai[t];
 	         		if (value<0)
 	         	    {	sgn=-1;
 	         	    	value=-value; 	         	    	
 	         	    }                
 	         	    m2=value%2; 	         		
 	         		value=(int)(((pInts[value>>1])<<1)+m2);
 	         		if (sgn<0)
 	         			datai[t]=-value;
 	         		else
 	         			datai[t]=value;
 	         		
 	    	 		t++;
 	    	 	 	
 	    	 	 	sgn=1;
 	         		value=datai[t];
 	         	    if (value<0)
 	         	    {	sgn=-1;
 	         	    	value=-value; 	         	    	
 	         	    }                
 	         	    m2=value%2; 	         		
 	         		value=(int)(((pInts[value>>1])<<1)+m2);
 	         		if (sgn<0)
 	         			datai[t]=-value;
 	         		else
 	         			datai[t]=value;
 	         		
 	    	 		t++;
 	    	 	}
 	        }
 	     	else	// 8-bit stereo
 	     	{	for (t=0;t<amount;)
 	    	 	{	
 	    	 		sgn=1;
 	         		value=(int)(data[t]-128);
 	         	    if (value<0)
 	         	    {	sgn=-1;
 	         	    	value=-value; 	         	    	
 	         	    }                
 	         	    m2=value%2; 	         		
 	         		value=(int)(((pInts[value<<7])<<1)+m2)>>8;
 	         		if (sgn<0)
 	         			data[t]=(unsigned char)(128-value);
 	         		else
 	         			data[t]=(unsigned char)(128+value);
 	         			
 	         		t++;
 	    	 	 	
 	    	 	 	sgn=1;
 	         		value=(int)(data[t]-128);
 	         	    if (value<0)
 	         	    {	sgn=-1;
 	         	    	value=-value; 	         	    	
 	         	    }                
 	         	    m2=value%2; 	         		
 	         		value=(int)(((pInts[value<<7])<<1)+m2)>>8;
 	         		if (sgn<0)
 	         			data[t]=(unsigned char)(128-value);
 	         		else
 	         			data[t]=(unsigned char)(128+value);
 	         		
 	    	 		t++;
 	    	 	} 	     	
 	        }
 	    }           
 	    
 	 	WriteData(ci,data,offset,amount);
 	 	offset+=amount;
 	 	ProgressMeter(ci,(origsize-length),origsize);
		if (*(ci->lpProgressCanceled)) 
			break;
 	 
	}
    
    ProgressDestroy(ci);
    
	GlobalUnlock(hInts);
	GlobalFree(hInts);
	
	GlobalUnlock(hBigMem);
	GlobalFree(hBigMem);
	hBigMem=0;
    
 	GlobalUnlock(hDistort);
    return 0;
}
    
void DialogToStruct(COOLINFO FAR *ci, HWND hWndDlg, DISTORT FAR * lpAmp)
{	//char tmp[30];
	                  
	
}

void StructToDialog(COOLINFO FAR *ci, DISTORT FAR *lpAmp, HWND hWndDlg)
{    //char tmp[30];                                               
	 HDC hDC;
	
	 hDC=GetDC(hWndDlg);
	 GraphDraw(ci,lpAmp->hGraph,hDC);
	 ReleaseDC(hWndDlg,hDC);    
}    
    
long longfromstring(char **cursor)
{   long l=0;
	while ((**cursor!=',') && (**cursor!=0x00))
	{	l=l*10+(long)(**cursor-'0');
		(*cursor)++;	
	}          
	if (**cursor!=0x00)  // skip over comma
		(*cursor)++;
 	
 	return l;
}
    
void CopyToDlgItem(HWND hWndDlg, int iControl,COOLINFO far *ci,HANDLE hDistort,  DISTORT FAR *lpAmp)
{   char m[80];
	wsprintf(m,"%ld,%d,%ld",lpAmp,hDistort,ci);
	SetDlgItemText(hWndDlg,iControl,m);	
}                                      

void CopyFromDlgItem(HWND hWndDlg, int iControl,  COOLINFO far **ci, HANDLE *hDistort, DISTORT FAR **lpAmp)
{	char m[80];
	char *cursor;         
	
	GetDlgItemText(hWndDlg,iControl,m,80);
	if (m[0]==0x00)
	{	*lpAmp=NULL;
		*hDistort=0;
		*ci=NULL;

		return;
	}                            
	cursor=m;
	*lpAmp=(DISTORT FAR *)longfromstring(&cursor);
	*hDistort=(HANDLE)longfromstring(&cursor);
	*ci=(COOLINFO far *)longfromstring(&cursor);
}    
    
BOOL FAR PASCAL __export DIALOGMsgProc(HWND hWndDlg, WORD Message, WORD wParam, LONG lParam)
{   DISTORT FAR * lpAmp = NULL;
	HANDLE hDistort = NULL;
	COOLINFO far *ci=NULL;
	
	switch(Message)
   	{case WM_INITDIALOG:
		{	ci=(COOLINFO far *)lParam;
			hDistort=ci->hUserData;         
			lpAmp=(DISTORT FAR *)GlobalLock(hDistort);
			
			CenterDialog(ci,hWndDlg);
	        GraphSetDblClkScales(ci,lpAmp->hGraph,1.0/16384.0,0,100,1.0/16384.0,0,100,1);
			GraphSetDblClkNames(ci,lpAmp->hGraph,"Input Sample","dB","Output Sample","dB");
			GraphSetDialog(ci,lpAmp->hGraph,hWndDlg,IDC_RECT,IDC_DISPLAY);
	        
	        if (!PresetsInit(ci, hWndDlg, TRANSFORMNAME))
	        {   WritePrivateProfileString(TRANSFORMNAME,"Item1",
          	  	"Fuzz,3,20,0,0,1033,1033,1047,2827,1838,1838,2720,2722,2721,5011,3667,3667,4292,4294,4293,6874,5301,5301,6179,6179,6229,8802,7226,7226,7904,7902,7905,10858,8849,8849,9996,10219,9997,13042,11000,10862,16384,16384",
          	  	ci->szIniFile);
          	  	WritePrivateProfileString(TRANSFORMNAME,"Item2",	
				"Quantize,3,18,0,0,2595,2596,2596,3269,3268,3269,3269,4115,4114,4115,4115,5181,5180,5181,5181,6522,6521,6522,6522,8211,8210,8211,8211,10337,10336,10337,10337,13014,13013,13014,13014,16384,16384,16384",
				ci->szIniFile);
				WritePrivateProfileString(TRANSFORMNAME,"Item3","No Distortion,3,2,0,0,16384,16384,none",ci->szIniFile);
				WritePrivateProfileString(TRANSFORMNAME,"Item4","Overdriven,3,9,0,0,680,3276,1570,6553,2931,9637,4763,12271,7118,14392,10102,15741,12772,16319,16384,16384",ci->szIniFile);
				WritePrivateProfileString(TRANSFORMNAME,"Item5","Cranked!,3,12,0,0,2826,15034,3297,16126,4030,16384,4920,16255,5862,14906,6647,12400,7642,8738,9003,4883,10992,2377,14551,514,16384,0",ci->szIniFile);
				WritePrivateProfileString(TRANSFORMNAME,"Item6","Bad FM Reception,3,6,0,0,522,578,523,3598,1099,3084,1413,1413,16384,16384",ci->szIniFile);
				WritePrivateProfileString(TRANSFORMNAME,"Item7","Light Fuzz,3,5,0,0,209,706,785,0,837,771,16384,16384",ci->szIniFile);
				WritePrivateProfileString(TRANSFORMNAME,"Item8","Maximum Loud,3,3,0,0,471,15355,16384,16384",ci->szIniFile);
                PresetsInit(ci,hWndDlg,TRANSFORMNAME);
          	}
	        
			CopyToDlgItem(hWndDlg,IDC_STORAGE,ci,hDistort,lpAmp);
			StructToDialog(ci, lpAmp, hWndDlg);
	
					// using scripts, auto OK it.
	 		if ((ci->iScriptFile!=-1) && (!ci->iScriptDialogStop))
		 		PostMessage(hWndDlg,WM_COMMAND,IDOK,0L);
	
		}	
    		
         break; /* End of WM_INITDIALOG                                 */

     case WM_CLOSE:
         /* Closing the Dialog behaves the same as Cancel               */
         PostMessage(hWndDlg, WM_COMMAND, IDCANCEL, 0L);
         break; /* End of WM_CLOSE                                      */
         
         
     case WM_LBUTTONDOWN:
          {	POINT here;
    	  	int whichpoint;
          	CopyFromDlgItem(hWndDlg,IDC_STORAGE,&ci,&hDistort,&lpAmp);			
         	here.x=LOWORD(lParam);
          	here.y=HIWORD(lParam);
          	whichpoint=GraphHandleWM_LBUTTONDOWN(ci,lpAmp->hGraph,here);
          }  
            break;
     case WM_LBUTTONUP:
          {	POINT here;
    	  	int whichpoint;
          	CopyFromDlgItem(hWndDlg,IDC_STORAGE,&ci,&hDistort,&lpAmp);			
         	here.x=LOWORD(lParam);
          	here.y=HIWORD(lParam);
          	whichpoint=GraphHandleWM_LBUTTONUP(ci,lpAmp->hGraph,here);
          }  
            break; 
 	case WM_MOUSEMOVE:
          {	POINT here;
    	  	int whichpoint;
          	CopyFromDlgItem(hWndDlg,IDC_STORAGE,&ci,&hDistort,&lpAmp);			
         	here.x=LOWORD(lParam);
          	here.y=HIWORD(lParam);
          	whichpoint=GraphHandleWM_MOUSEMOVE(ci,lpAmp->hGraph,here);
          }  
            break;
    case WM_LBUTTONDBLCLK:
         {	POINT here;
			CopyFromDlgItem(hWndDlg,IDC_STORAGE,&ci,&hDistort,&lpAmp);			
         	here.x=LOWORD(lParam);
			here.y=HIWORD(lParam);
			GraphHandleWM_LBUTTONDBLCLK(ci,lpAmp->hGraph,here);			
         }
    	 break;            
          
    case WM_PAINT:
    	 {HDC hDC;
    	  PAINTSTRUCT ps;
    	  CopyFromDlgItem(hWndDlg,IDC_STORAGE,&ci,&hDistort,&lpAmp);			
          hDC=BeginPaint(hWndDlg,&ps);
          GraphDraw(ci,lpAmp->hGraph,hDC);
          EndPaint(hWndDlg,&ps);
          return FALSE;
    	 };

    
   case WM_COMMAND:
         CopyFromDlgItem(hWndDlg,IDC_STORAGE,&ci,&hDistort,&lpAmp);			
         switch(wParam)
           {  case IDC_HELP:
           		 WinHelp(hWndDlg,XFM_HELPFILE,HELP_KEY,(DWORD)((LPSTR)"Distort"));
                 break;  
              case ID_PRESETS:
                 if (HandleID_PRESETS(ci, hWndDlg, TRANSFORMNAME, lParam))
                 {	StructToDialog(ci, lpAmp, hWndDlg);                    
                 }
                 break;
              case ID_ADD:
              	DialogToStruct(ci, hWndDlg, lpAmp);
              	HandleID_ADD(ci, hWndDlg, TRANSFORMNAME);       
              	break; 	 
              case ID_DEL:
              	HandleID_DEL(ci, hWndDlg, TRANSFORMNAME);
              	break;
              case ID_PRESETNAME:
              	HandleID_PRESETNAME(ci, hWndDlg);
              	break;	
                case IDOK:
              {	  if (GetFocus()==GetDlgItem(hWndDlg,ID_PRESETS))
                  {	PostMessage(hWndDlg,WM_COMMAND,ID_PRESETS,MAKELONG(GetDlgItem(hWndDlg,ID_PRESETS),LBN_DBLCLK));
                    break;
                  }
              	  DialogToStruct(ci, hWndDlg,lpAmp);
                   	
             	  GlobalUnlock(hDistort); 
             	  hDistort=NULL;
                  EndDialog(hWndDlg, TRUE);
               }
            	 break;                                                    
              case IDCANCEL:
                 /* Ignore data values entered into the controls        */
                 /* and dismiss the dialog window returning FALSE       */
                 GlobalUnlock(hDistort);
                 hDistort=NULL;
                 EndDialog(hWndDlg, FALSE);
                 break;
           }
         break;    /* End of WM_COMMAND                                 */

    default:
		return FALSE;
   }
 
 	return TRUE;
}
